# Vespucci 11.0 Highlights
 
2018-06-28

## Layer control

The most obvious visual difference in version 11 is the layer control on the main map view. 

Currently it is not possible to change the ordering or add more than one layer of a specific type, supported functionality:  

* Hide/Show button turns drawing of the layer off/on. Hiding a layer doesn't free any resources associated with the layer.
* Zoom to extent. Zooms and pans the screen so that the whole extent of the layer is displayed, if the extent cannot be determined this will zoom out to the full web-mercator coverage. Note: on the data layer this may not be particularly useful if you have downloaded areas that are far apart.
* Menu button.
    * Tile based layers: 
        * Select imagery. Same contents as on the preference screen, if multiple layers have been used, a most-recently-used list will be displayed above this menu entry, allowing quick layer switching. Selecting the "None" entry from the list will disable the layer, and requires re-enabling it via the "+" button on the layer dialog.
        * Flush tile cache. Moved here from main menu.
        * Background properties. Set contrast of layer, moved here from main menu.
    * GeoJSON layer. 
        * Change style. Show the layer styling dialog.
        * Discard. Delete the layer including any saved state.
    * GPX layer. The GPX layer is currently mainly controlled via the entries in the GPS menu.
        * Change style. Show the layer styling dialog.
    * Photo, Grid and Task layers.
        * Disable. Turn this layer off, needs to be re-enbled via preferences. For the tasks and photo layers this will free resources if the app is exited and re-started.
* "+" button: 
    * Load GeoJSON layer. Loads a GeoJSON layer from a file, any existing one will be replaced.
    * Map background. Shown if the background layer has been disabled, allows the same selection as from the preferences screen.
    * Map overlay. Shown if the overlay layer has been disabled, allows the same selection as from the preferences screen.
        

## Support for GeoJSON layers

A single (currently) GeoJSON based layer can be displayed on the map, individual elements are selectable. On loading the GeoJSON data from a file colour, stroke width and a tag for displaying a label can be selected.

A typical use case would be to verify third party data in GeoJSON format on the ground and similar mapping activities. 

## Re-arranged Preferences

The two preferences screens have been re-arranged with just the most important settings on the first screen and the "Advanced preference" screen split up in to multiple sub-screens.

The Authors and Licence screen has been move to the main menu, just as the Debug screen has.

## Undo/redo of individual checkpoints

Previously selecting an undo or redo checkpoint from the undo menu (long press on the undo icon), always undid/redid all checkpoints back to that point in time. In Vespucci 11 a dialog is shown that allows you to select the previous behaviour or to undo/redo just the single selected checkpoint.

While selecting just one checkpoint will result in consistent data, it may have unintended consequences as all elements changed in the checkpoint will be reinstated to the stored state when the checkpoint was created, except if elements are referenced, for example way nodes or relation members, that have been deleted in later edits. References to deleted objects will not be re-created, including relation memberships in later deleted relations.

Example: as the first operation you split a way, as the second step you delete one of the two halves of the way. Undoing the first operation will only add way nodes back that were not removed in the second step.

Simple tag changes in a checkpoint can in general be undone without negative consequences.

## Review changes before upload

Entries on the list of the created, changed and deleted elements can now be selected and the actual changes inspected. Elements that have failed the validator tests will have a red icon displayed. 

## Auto-Presets from taginfo

The results in the preset search are now complemented by results from querying Jochen Topfs [taginfo service](https://taginfo.openstreetmap.org/), currently this requires network connectivity to work and will only return results for tags that have at least one wiki page. In general so generated presets should not be taken as gospel and the tagging will typically need some manual work. 

Selected search results from taginfo are added to a special preset file that is stored on device in the public Vespucci directory, this can be used as a starting point for creating a proper preset for the object in question. 

This feature can be turned off in the Advanced preferences "Data and Editing settings". 

## Improved country specific tagging

It is now possible to add more country specific tagging rules. For now, besides the already existing check for use of imperial units in a territory, we support lists of speed limits for use in the property editor, if info is missing for your country you can provide them at [geocontext repository](https://github.com/simonpoole/geocontext). 

## Miscellaneous 

* Support for icons in preset combos and multi-selects.
* The info display for selected elements will now show the original state of the element side by side with the current state if the element has been modified.
* Bugs and Notes that have been closed but not uploaded yet, have their own, not very distinctive, blue-green icon.
* Fields declared as phone or fax numbers in a preset will show the devices phone number keyboard.
* Free form preset text fields that neither have an existing value nor pre-defined values will have device text suggestions and spelling correction enabled (note this will not be the case for "name" tags).
* Implement the "values_from" attribute in presets including an extension to the JOSM implementation of passing the key as an argument if possible.
* Support for RTL scripts added, caveat the openinghours editor is not converted yet (as there are no such translations) and there may be minor inconsistencies.

The full change log is available [here](https://github.com/MarcusWolschon/osmeditor4android/commits/master)

# Upgrading from previous versions

# Known problems

* For known problems with this build please see [our issue tracker](https://github.com/MarcusWolschon/osmeditor4android/issues)

